// Import the ready-to-use db object from our central init file
import { db } from './firebase-init.php';

// Import only the functions we need for this page from the Firestore SDK
import { collection, onSnapshot } from "https://www.gstatic.com/firebasejs/11.6.1/firebase-firestore.js";

// DOM elements
const faqContainer = document.getElementById('faq-container');
const faqLoadingMessage = document.getElementById('faq-loading-message');

// Function to render FAQs
const renderFaqs = (snapshot) => {
    if(!faqContainer) return;
    faqContainer.innerHTML = '';
    if (snapshot.docs.length === 0) {
        faqContainer.innerHTML = `<p class="text-gray-400 text-center mt-8">No FAQs available yet.</p>`;
    }
    snapshot.forEach(doc => {
        const faq = { id: doc.id, ...doc.data() };
        const faqHtml = `
            <div class="rounded-lg bg-gray-800/50 p-4 shadow-lg cursor-pointer transition-transform transform hover:scale-[1.02] duration-300 faq-item">
                <div class="flex items-center justify-between">
                    <h3 class="text-xl sm:text-2xl text-amber-400 font-normal">${faq.question || 'N/A'}</h3>
                    <i class="fas fa-plus text-white faq-icon"></i>
                </div>
                <p class="text-gray-300 mt-2 faq-answer">${faq.answer || 'N/A'}</p>
            </div>
        `;
        faqContainer.innerHTML += faqHtml;
    });
    
    document.querySelectorAll('.faq-item').forEach(item => {
        item.addEventListener('click', () => {
            item.querySelector('.faq-answer').classList.toggle('show');
            item.querySelector('.faq-icon').classList.toggle('rotate');
        });
    });
};

// --- Real-time Listener for the FAQs ---
const initializeAboutPage = () => {
    if(faqLoadingMessage) faqLoadingMessage.classList.remove('hidden');

    onSnapshot(collection(db, 'faqs'), (snapshot) => {
        renderFaqs(snapshot);
        if(faqLoadingMessage) faqLoadingMessage.classList.add('hidden');
    });
};

window.addEventListener('DOMContentLoaded', initializeAboutPage);