// Import the ready-to-use db object from our central init file
import { db } from './firebase-init.php';

// Import the specific functions we need from the Firestore SDK
import { collection, addDoc, serverTimestamp } from "https://www.gstatic.com/firebasejs/11.6.1/firebase-firestore.js";

// DOM elements
const contactForm = document.getElementById('contact-form');
const formStatus = document.getElementById('form-status');

// --- Contact Form Submission ---
if(contactForm) {
    contactForm.addEventListener('submit', async (e) => {
        e.preventDefault();
        const formData = {
            name: contactForm.name.value,
            email: contactForm.email.value,
            phone: contactForm.phone.value,
            message: contactForm.message.value,
            timestamp: serverTimestamp(),
            status: 'new'
        };

        try {
            await addDoc(collection(db, 'contact_messages'), formData);
            formStatus.textContent = 'Your message has been sent successfully!';
            formStatus.classList.remove('hidden', 'text-red-400');
            formStatus.classList.add('text-green-400');
            contactForm.reset();
        } catch (error) {
            console.error('Error sending message:', error);
            formStatus.textContent = 'Failed to send message. Please try again later.';
            formStatus.classList.remove('hidden', 'text-green-400');
            formStatus.classList.add('text-red-400');
        } finally {
            formStatus.classList.remove('hidden');
            setTimeout(() => {
                formStatus.classList.add('hidden');
                formStatus.textContent = ''; // Clear text after hiding
            }, 5000);
        }
    });
}