<?php
// Set the content type to JavaScript
header('Content-Type: application/javascript');

// Define the ABSOLUTE path to your secure keys.ini file.
$configPath = '/home/vnejapguxa/keys.ini';

if (file_exists($configPath)) {
    $config = parse_ini_file($configPath, true);
    $firebaseConfig = $config['firebase'];
} else {
    echo "console.error('CRITICAL: Configuration file not found. API keys could not be loaded.');";
    exit();
}
?>

// Import all necessary Firebase functions directly from the CDN
import { initializeApp } from "https://www.gstatic.com/firebasejs/11.6.1/firebase-app.js";
import { getFirestore } from "https://www.gstatic.com/firebasejs/11.6.1/firebase-firestore.js";
import { getAuth } from "https://www.gstatic.com/firebasejs/11.6.1/firebase-auth.js";
import { initializeAppCheck, ReCaptchaV3Provider } from "https://www.gstatic.com/firebasejs/11.6.1/firebase-app-check.js";

// Define the config using the PHP variables
const firebaseConfig = {
    apiKey: "<?php echo $firebaseConfig['apiKey']; ?>",
    authDomain: "<?php echo $firebaseConfig['authDomain']; ?>",
    projectId: "<?php echo $firebaseConfig['projectId']; ?>",
    storageBucket: "<?php echo $firebaseConfig['storageBucket']; ?>",
    messagingSenderId: "<?php echo $firebaseConfig['messagingSenderId']; ?>",
    appId: "<?php echo $firebaseConfig['appId']; ?>",
    measurementId: "<?php echo $firebaseConfig['measurementId']; ?>"
};

// Initialize the Firebase app
const app = initializeApp(firebaseConfig);

// Initialize App Check
initializeAppCheck(app, {
  provider: new ReCaptchaV3Provider('6LddpekrAAAAABRgsQhS5VUHYXbI8fevFPKiU0HO'),
  isTokenAutoRefreshEnabled: true
});

// Initialize Firestore and Auth services
const db = getFirestore(app);
const auth = getAuth(app);

// EXPORT the initialized services for other files to use
export { db, auth };