// This file contains scripts that are shared across multiple pages of the website.

// Mobile menu toggle
const mobileMenuButton = document.getElementById('mobile-menu-button');
const mobileMenu = document.getElementById('mobile-menu');
const mobileMenuIcon = document.getElementById('mobile-menu-icon');

if (mobileMenuButton) {
    mobileMenuButton.addEventListener('click', () => {
        mobileMenu.classList.toggle('max-h-0');
        mobileMenu.classList.toggle('max-h-[500px]');
        mobileMenuIcon.classList.toggle('fa-bars');
        mobileMenuIcon.classList.toggle('fa-xmark');
    });
}

// Navbar and scroll-to-top button logic
const scrollToTopBtn = document.getElementById('scrollToTopBtn');
const navbar = document.getElementById('navbar');

function showOrHideNavbar() {
    if (navbar) {
        if (window.scrollY > 100) {
            navbar.classList.add('navbar-hidden');
            navbar.classList.remove('navbar-visible');
        } else {
            navbar.classList.remove('navbar-hidden');
            navbar.classList.add('navbar-visible');
        }
    }
}
function showOrHideScrollToTop() {
    if (scrollToTopBtn) {
        if (window.scrollY > 200) {
            scrollToTopBtn.classList.remove('hidden');
        } else {
            scrollToTopBtn.classList.add('hidden');
        }
    }
}
window.addEventListener('scroll', () => {
    showOrHideNavbar();
    showOrHideScrollToTop();
});

if (scrollToTopBtn) {
    scrollToTopBtn.addEventListener('click', () => {
        window.scrollTo({ top: 0, behavior: 'smooth' });
    });
}

// Hero section mobile slider logic
const sliderWrapper = document.getElementById('mobile-slider-wrapper');
if (sliderWrapper) {
    let currentSlideIndex = 0;
    let sliderInterval;

    function updateSlider() {
        const items = sliderWrapper.querySelectorAll('.slider-item');
        if (items.length > 0) {
            const itemWidth = items[0].offsetWidth;
            currentSlideIndex = (currentSlideIndex + 1) % items.length;
            sliderWrapper.style.transform = `translateX(-${currentSlideIndex * itemWidth}px)`;
        }
    }

    function startSlider() {
        if (window.matchMedia("(max-width: 767px)").matches) {
            sliderInterval = setInterval(updateSlider, 3000);
        }
    }
    function stopSlider() {
        clearInterval(sliderInterval);
    }
    window.addEventListener('resize', () => {
        stopSlider();
        startSlider();
    });

    window.addEventListener('DOMContentLoaded', () => {
        startSlider();
    });
}

